// @author: Tim Heng, bheng@sfu.ca

import controlP5.*; //importing controlP5


//declaring variables
ControlP5 cp5;

PFont font;

String data[], chunks[];

ScatterPlotPoint myData[]; //ScatterPlotPoint type array to hold objects

float x_axis_filter, y_axis_filter;

String selectedX, selectedY, selectedColor, selectedSize, selectedOrientation;

color setosaColor, versiColor, virginicaColor;

ListBox xBox, yBox, colorBox, sizeBox, shapeBox;

void setup() {

  size (1200, 700);

  setosaColor = color (22, 147, 165);        //dutch teal
  versiColor = color (251, 184, 41);         //heart of gold
  virginicaColor = color (164, 54, 75);      //red

  cp5 = new ControlP5(this);

  //read the csv file
  data = loadStrings ( "IrisDataset.csv" );

  font = loadFont("Nilland-48.vlw");

  myData = new ScatterPlotPoint[data.length-1];

  //splitting the values
  for (int i=1; i<data.length; i++ ) {
    chunks = split(data[i], ","); 
    myData[i-1] = new ScatterPlotPoint(Float.valueOf(chunks[0]), Float.valueOf(chunks[1]), Float.valueOf(chunks[2]), Float.valueOf(chunks[3]), chunks[4]);
  }

  //add listboxes
  xBox = cp5.addListBox("X Axis", 1020, 50, 120, 120);
  xBox.addItem("Sepal Length", 0);
  xBox.addItem("Sepal Width", 1);
  xBox.addItem("Petal Length", 2);
  xBox.addItem("Petal Width", 3);

  yBox = cp5.addListBox("Y Axis", 1020, 150, 120, 120);
  yBox.addItem("Sepal Length", 0);
  yBox.addItem("Sepal Width", 1);
  yBox.addItem("Petal Length", 2);
  yBox.addItem("Petal Width", 3);

  colorBox = cp5.addListBox("Color", 1020, 250, 120, 120);
  colorBox.addItem("Sepal Length", 0);
  colorBox.addItem("Sepal Width", 1);
  colorBox.addItem("Petal Length", 2);
  colorBox.addItem("Petal Width", 3);
  colorBox.addItem("Species", 4);

  sizeBox = cp5.addListBox("Size", 1020, 350, 120, 120);
  sizeBox.addItem("Sepal Length", 0);
  sizeBox.addItem("Sepal Width", 1);
  sizeBox.addItem("Petal Length", 2);
  sizeBox.addItem("Petal Width", 3);

  shapeBox = cp5.addListBox("Orientation", 1020, 450, 120, 120);
  shapeBox.addItem("Sepal Length", 0);
  shapeBox.addItem("Sepal Width", 1);
  shapeBox.addItem("Petal Length", 2);
  shapeBox.addItem("Petal Width", 3);
  shapeBox.addItem("Species", 4);

  //add the x and y slider filters
  cp5.addSlider("y_axis_filter")
    .setPosition(1010, 615)
      .setSize(120, 10)
        .setRange(0.1, 10)
          .setValue(5);

  cp5.addSlider("x_axis_filter")
    .setPosition(1010, 600)
      .setSize(120, 10)
        .setRange(0.1, 10)
          .setValue(5);
}


void draw() {

  drawTemplate();  //draw the basic layout of the program
  
  //run through array and plot the points on the canvas
  for (int i=0; i < myData.length; i++) {
    myData[i].plot(x_axis_filter, y_axis_filter);
  }
}


//controlEvent for the listboxes
void controlEvent(ControlEvent theEvent) {

  if (theEvent.isGroup() && theEvent.name().equals("X Axis")) {

    //if Sepal Length is selected
    if (theEvent.group().value()==0) {
      selectedX = "Sepal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setXPos(myData[i].getSepal_length());
      }
    }

    //if Sepal Width is selected
    if (theEvent.group().value()==1) {
      selectedX = "Sepal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setXPos(myData[i].getSepal_width());
      }
    }

    //if Petal Length is selected
    if (theEvent.group().value()==2) {
      selectedX = "Petal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setXPos(myData[i].getPetal_length());
      }
    }

    //if Petal Width is selected
    if (theEvent.group().value()==3) {
      selectedX = "Petal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setXPos(myData[i].getPetal_width());
      }
    }
  }

  if (theEvent.isGroup() && theEvent.name().equals("Y Axis")) {

    //if Sepal Length is selected
    if (theEvent.group().value()==0) {
      selectedY = "Sepal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setYPos(myData[i].getSepal_length());
      }
    }

    //if Sepal Width is selected
    if (theEvent.group().value()==1) {
      selectedY = "Sepal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setYPos(myData[i].getSepal_width());
      }
    }

    //if Petal Length is selected
    if (theEvent.group().value()==2) {
      selectedY = "Petal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setYPos(myData[i].getPetal_length());
      }
    }

    //if Petal Width is selected
    if (theEvent.group().value()==3) {
      selectedY = "Petal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setYPos(myData[i].getPetal_width());
      }
    }
  }

  if (theEvent.isGroup() && theEvent.name().equals("Color")) {

    //if Sepal Length is selected
    if (theEvent.group().value()==0) {
      selectedColor = "Sepal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setColor(myData[i].getSepal_length()*10);
      }
    }

    //if Sepal Width is selected
    if (theEvent.group().value()==1) {
      selectedColor = "Sepal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setColor(myData[i].getSepal_width()*10);
      }
    }

    //if Petal Length is selected
    if (theEvent.group().value()==2) {
      selectedColor = "Petal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setColor(myData[i].getPetal_length()*10);
      }
    }

    //if Petal Width is selected
    if (theEvent.group().value()==3) {
      selectedColor = "Petal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setColor(myData[i].getPetal_width()*10);
      }
    }

    //if Species is selected
    if (theEvent.group().value()==4) {
      selectedColor = "Species";
      for (int i=0; i < myData.length; i++) {
        if ((myData[i].getSpecies()).equals("setosa")) myData[i].setColor(setosaColor);
        if ((myData[i].getSpecies()).equals("versicolor")) myData[i].setColor(versiColor);
        if ((myData[i].getSpecies()).equals("virginica")) myData[i].setColor(virginicaColor);
      }
    }
  }

  if (theEvent.isGroup() && theEvent.name().equals("Size")) {

    //if Sepal Length is selected
    if (theEvent.group().value()==0) {
      selectedSize = "Sepal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setSize(myData[i].getSepal_length());
      }
    }

    //if Sepal Width is selected
    if (theEvent.group().value()==1) {
      selectedSize = "Sepal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setSize(myData[i].getSepal_width());
      }
    }

    //if Petal Length is selected
    if (theEvent.group().value()==2) {
      selectedSize = "Petal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setSize(myData[i].getPetal_length());
      }
    }

    //if Petal Width is selected
    if (theEvent.group().value()==3) {
      selectedSize = "Petal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setSize(myData[i].getPetal_width());
      }
    }
  }

  if (theEvent.isGroup() && theEvent.name().equals("Orientation")) {

    //if Sepal Length is selected
    if (theEvent.group().value()==0) {
      selectedOrientation = "Sepal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setOrientation(myData[i].getSepal_length());
      }
    }

    //if Sepal Width is selected
    if (theEvent.group().value()==1) {
      selectedOrientation = "Sepal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setOrientation(myData[i].getSepal_width());
      }
    }

    //if Petal Length is selected
    if (theEvent.group().value()==2) {
      selectedOrientation = "Petal Length";
      for (int i=0; i < myData.length; i++) {
        myData[i].setOrientation(myData[i].getPetal_length());
      }
    }

    //if Petal Width is selected
    if (theEvent.group().value()==3) {
      selectedOrientation = "Petal Width";
      for (int i=0; i < myData.length; i++) {
        myData[i].setOrientation(myData[i].getPetal_width());
      }
    }

    //if Species is selected
    if (theEvent.group().value()==4) {
      selectedOrientation = "Species";
      for (int i=0; i < myData.length; i++) {
        if ((myData[i].getSpecies()).equals("setosa")) myData[i].setOrientation(45);
        if ((myData[i].getSpecies()).equals("versicolor")) myData[i].setOrientation(90);
        if ((myData[i].getSpecies()).equals("virginica")) myData[i].setOrientation(180);
      }
    }
  }
}


//function to draw the layout
void drawTemplate() {
  fill(255);
  noStroke();
  rect(0, 0, 1000, 700);


  fill(0);
  textFont(font, 14);
  textAlign(LEFT);
  //Y axis
  //text("Y Axis", 30, 20);
  text(String.valueOf(nf(y_axis_filter, 1, 3)), 30, 55);
  text(String.valueOf(nf(y_axis_filter/3*2, 1, 3)), 30, 255);
  text(String.valueOf(nf(y_axis_filter/3, 1, 3)), 30, 455);
  text("0", 50, height-30);

  //X axis
  //text("X Axis", 900, height-30);
  textAlign(CENTER);
  text(String.valueOf(nf(x_axis_filter/4, 1, 3)), 275, height-30);
  text(String.valueOf(nf(x_axis_filter/4*2, 1, 3)), 475, height-30);
  text(String.valueOf(nf(x_axis_filter/4*3, 1, 3)), 675, height-30);
  text(String.valueOf(nf(x_axis_filter, 1, 3)), 875, height-30);

  // Selected variables
  fill(0);
  textFont(font, 14);
  textAlign(LEFT);
  text("X Axis: "+selectedX, 200, 20);
  text("Y Axis: "+selectedY, 350, 20);
  text("Color: "+selectedColor, 500, 20);
  text("Size: "+selectedSize, 650, 20);
  text("Orientation : "+selectedOrientation, 800, 20);

  //axes
  stroke(0);
  strokeWeight(2);
  line(75, 25, 75, height-50);
  line(75, height-50, 925, height-50);

  //grids
  strokeWeight(1);
  stroke(230);

  //verticle lines
  line(125, 50, 125, height-50);
  line(175, 50, 175, height-50);
  line(225, 50, 225, height-50);
  stroke(150);
  line(275, 50, 275, height-50);
  stroke(230);
  line(325, 50, 325, height-50);
  line(375, 50, 375, height-50);
  line(425, 50, 425, height-50);
  stroke(150);
  line(475, 50, 475, height-50);
  stroke(230);
  line(525, 50, 525, height-50);
  line(575, 50, 575, height-50);
  line(625, 50, 625, height-50);
  stroke(150);
  line(675, 50, 675, height-50);
  stroke(230);
  line(725, 50, 725, height-50);
  line(775, 50, 775, height-50);
  line(825, 50, 825, height-50);
  stroke(150);
  line(875, 50, 875, height-50);
  stroke(230);
  //horizontal lines
  stroke(150);
  line(75, 50, 875, 50);
  stroke(230);
  line(75, 100, 875, 100);
  line(75, 150, 875, 150);
  line(75, 200, 875, 200);
  stroke(150);
  line(75, 250, 875, 250);
  stroke(230);
  line(75, 300, 875, 300);
  stroke(230);
  line(75, 350, 875, 350);
  line(75, 400, 875, 400);
  stroke(150);
  line(75, 450, 875, 450);
  stroke(230);
  line(75, 500, 875, 500);
  line(75, 550, 875, 550);
  line(75, 600, 875, 600);
}

